uniform vec2 u_horizonUV;
uniform vec2 u_offsetUnit;
uniform float u_steps;
varying vec2 v_texCoord;

void main()
{
    vec2 dir = u_horizonUV - v_texCoord;
    dir /= u_horizonUV;
    dir *= u_offsetUnit;
    
    vec4 cellCol = texture2D(CC_Texture1, v_texCoord);
    cellCol = mix(texture2D(CC_Texture1, v_texCoord - dir * 2.0), cellCol, cellCol.a);
    cellCol = mix(texture2D(CC_Texture1, v_texCoord - dir * 3.0), cellCol, cellCol.a);
    cellCol = mix(texture2D(CC_Texture1, v_texCoord - dir * 4.0), cellCol, cellCol.a);
    cellCol = mix(texture2D(CC_Texture1, v_texCoord - dir * 5.0), cellCol, cellCol.a);
    
    cellCol.rgb *= 0.75;
    
    gl_FragColor = cellCol;
    
}
